function [moment cm]=one_step_expect_monomials(high_degree,x,A,Y)
global mu moment;
n=length(x);
clear s;
s(1,:)=ones(1,high_degree);
for j=1:high_degree
    s(2,j)=j+1;
    if n>3
        error('Have not figured out the rule for producing monomials with higher than 3 order');
    else if n==3
        s(3,j)=(j+1)*(j+2)/2;
        end
    end
end

%fun_basis=monomials(x,1:high_degree);
fun_basis_deg=monomials(x.varname,1:high_degree); % double type matrix including degree of monomials.
mu=A*x;

moment=polynomial;
num=size(fun_basis_deg);

disp('Generating the expected value function of the polynomial.');

pvar y1 y2 y3;
y=[y1;y2;y3];
for i=1:n
    f(1,i)=y(i)-mu(i);
    moment(1,i)=mu(i);
    cm(i)=0;
end
str=['y1';'y2';'y3'];
for i=n+1:num(1)
    cm(i)=central_moment(fun_basis_deg(i,:),Y);
    ind=1;
    while fun_basis_deg(i,ind)==0
        ind=ind+1;
    end
    deg_tend=fun_basis_deg(i,:);
    deg_tend(ind)=deg_tend(ind)-1;
    
    pos=position(deg_tend,s);
    tend=ceil(pos/57);
    f1=y(ind)*f(tend,pos-57*(tend-1));
    f2=-mu(ind)*f(tend,pos-57*(tend-1));
    
    tend=ceil(i/57);
    f(tend,i-57*(tend-1))=f1+f2;
    if sum(f(tend,i-57*(tend-1)).degmat(length(f1.coefficient),:))>sum(fun_basis_deg(i,:))
        f1
    end
    %%%%%%%%%  calculate E(y1y2y3...ym)=cm- %%%%%%%%%%%%%%
    % find 'y' variables
    E_f=-mu(ind)*cm(pos);
    ind=1;
    while strncmp(f1.varname(ind),'y',1)==0
        ind=ind+1;
    end   
    dim_num=length(f1.varname);
    ty_deg_flag=zeros(1,n);
    kk=1;
    for k=ind:dim_num
        while strcmp(f1.varname(k),str(kk,:))==0
            kk=kk+1;
        end
        ty_deg_flag(kk)=1;        
    end        
    for j=1:length(f1.coefficient)
        % separate x term from y term in each monomial
        tx=polynomial(f1.coefficient(j),f1.degmat(j,1:ind-1),f1.varname(1:ind-1),[1 1]);      
        ty_deg=zeros(1,n);
        for k=1:n
            if ty_deg_flag(k)==1
                ty_deg(k)=f1.degmat(j,ind+sum(ty_deg_flag(1:k))-1);
            end
        end
        if sum(ty_deg)~=sum(fun_basis_deg(i,:))
            pos=position(ty_deg,s);
            if pos>0
                tend=ceil(pos/57);
                E_f=E_f+tx*moment(tend,pos-57*(tend-1));
            else
                E_f=E_f+tx;
            end
        end
    end
    tend=ceil(i/57);
    moment(tend,i-57*(tend-1))=cm(i)-E_f;
    fprintf('Generating the expected value function of term %d of %d terms.\n', i, num(1));
end